#include "unixtime_parser.h"

#include <util/string/cast.h>

using namespace NCrypta;

TMaybe<ui64> NUnixtimeParser::Parse(const TString& value) {
    static const size_t LENGTH = 10;

    if (value.size() != LENGTH) {
        return Nothing();
    }

    ui64 unixtime;
    if (!TryFromString<ui64>(value, unixtime)) {
        return Nothing();
    }

    return unixtime;
}
