#include "url_utils.h"

#include <kernel/urlnorm/normalize.h>

#include <library/cpp/uri/uri.h>

#include <util/charset/utf8.h>
#include <util/string/cast.h>
#include <util/string/split.h>
#include <library/cpp/string_utils/url/url.h>

using namespace NCrypta;

TString NUrlUtils::MakeUrl(TStringBuf scheme, TStringBuf host, ui16 port, TStringBuf path, const TCgiParameters& params) {
    NUri::TUri uri(host, port, path, params.Print(), scheme);

    return uri.PrintS();
}

TMaybe<TString> NUrlUtils::ExtractHost(const TStringBuf& url) {
    TString normalizedUrl;
    if (!NUrlNorm::NormalizeUrl(url, normalizedUrl)) {
        return Nothing();
    }

    TStringBuf host = GetOnlyHost(normalizedUrl);
    if (host.empty()) {
        return Nothing();
    };

    const auto& domainLevel = StringSplitter(host).Split('.').Count();

    if (domainLevel > 2) {
        host = CutWWWNumberedPrefix(host);
    }

    if (host.Contains('.')) {
        return ToString(host);
    }

    return Nothing();
}
