#pragma once

#include <crypta/lib/native/yaml/parse_yaml_file.h>
#include <crypta/lib/native/yaml/yaml2proto.h>

#include <library/cpp/getopt/small/last_getopt.h>

namespace NCrypta {
    template <typename TConfigProto>
    TConfigProto ParseYamlConfig(int argc, const char** argv, const TString& paramName = "config") {
        TString configFile;

        NLastGetopt::TOpts opts = NLastGetopt::TOpts::Default();
        opts.AddHelpOption();
        opts.AddLongOption(paramName).StoreResult(&configFile).RequiredArgument(paramName).Required();
        NLastGetopt::TOptsParseResult res(&opts, argc, argv);

        return Yaml2Proto<TConfigProto>(ParseYamlFile(configFile));
    }
}
