#include "yaml2proto.h"

#include "yaml2json.h"

#include <crypta/lib/native/cmd_args/parse_pb_options.h>

#include <util/string/subst.h>

namespace NCrypta {
    NProtobufJson::TJson2ProtoConfig GetDefaultYaml2ProtoConfig() {
        return {
            .FieldNameMode = NProtobufJson::TJson2ProtoConfig::FieldNameSnakeCase,
            .CastRobust = true,
            .MapAsObject = true,
            .EnumValueMode = NProtobufJson::TJson2ProtoConfig::EnumCaseInsensetive,
        };
    }

    void Yaml2Proto(const YAML::Node& yamlNode, google::protobuf::Message& proto, const NProtobufJson::TJson2ProtoConfig& config) {
        try {
            proto.Clear();
            const auto& jsonNode = Yaml2Json(yamlNode);
            ProcessCryptaExtensions(&proto);
            NProtobufJson::MergeJson2Proto(jsonNode, proto, config);
        } catch (const yexception& e) {
            TString exceptionMessage(e.what());
            SubstGlobal(exceptionMessage, "JSON", "YAML");
            SubstGlobal(exceptionMessage, "json", "yaml");
            ythrow yexception() << exceptionMessage;
        }
    }

    void Yaml2Proto(const TString& yamlStr, google::protobuf::Message& proto, const NProtobufJson::TJson2ProtoConfig& config) {
        Yaml2Proto(YAML::Load(yamlStr), proto, config);
    }
}
