#pragma once

#include <library/cpp/protobuf/json/json2proto.h>

#include <google/protobuf/message.h>
#include <contrib/libs/yaml-cpp/include/yaml-cpp/yaml.h>

namespace NCrypta {
    NProtobufJson::TJson2ProtoConfig GetDefaultYaml2ProtoConfig();

    void Yaml2Proto(const YAML::Node& yamlNode, google::protobuf::Message& proto, const NProtobufJson::TJson2ProtoConfig& config = GetDefaultYaml2ProtoConfig());
    void Yaml2Proto(const TString& yamlStr, google::protobuf::Message& proto, const NProtobufJson::TJson2ProtoConfig& config = GetDefaultYaml2ProtoConfig());

    template <typename TProto>
    TProto Yaml2Proto(const TString& yamlStr, const NProtobufJson::TJson2ProtoConfig& config = GetDefaultYaml2ProtoConfig()) {
        TProto proto;
        Yaml2Proto(yamlStr, proto, config);
        return proto;
    }

    template <typename TProto>
    TProto Yaml2Proto(const YAML::Node& yamlNode, const NProtobufJson::TJson2ProtoConfig& config) {
        TProto proto;
        Yaml2Proto(yamlNode, proto, config);
        return proto;
    }

    template <typename TProto>
    TProto Yaml2Proto(const YAML::Node& yamlNode) {
        return Yaml2Proto<TProto>(yamlNode, GetDefaultYaml2ProtoConfig());
    }
}
