#include <crypta/lib/native/yaml/ytree_node/serialize.h>

#include <library/cpp/testing/unittest/registar.h>
#include <library/cpp/yaml/as/tstring.h>

#include <yt/yt/core/ytree/convert.h>

namespace {
    const TString& yamlStr = "Name: Solar\n"
                             "Star: Sun\n"
                             "Planets:\n"
                             "  - Name: Mercury\n"
                             "    Radius: 2439.7\n"
                             "  - Name: Venus\n"
                             "    Radius: 6051.8\n"
                             "  - Name: Earth\n"
                             "    Radius: 6371\n"
                             "    Population: 7530000000\n"
                             "  - Name: Mars\n"
                             "    Radius: 3389.5\n"
                             "  - Name: Jupiter\n"
                             "  - Name: Saturn\n"
                             "  - Name: Uranus\n"
                             "  - Name: Neptune";
} // namespace

Y_UNIT_TEST_SUITE(NYTreeSerialize) {
    Y_UNIT_TEST(ConvertToNodePositive) {
        YAML::Node map = YAML::Load(yamlStr);

        auto system = NYT::NYTree::ConvertToNode(map)->AsMap();

        UNIT_ASSERT_STRINGS_EQUAL("Solar", system->GetChildOrThrow("Name")->AsString()->GetValue());

        auto planets = system->GetChildOrThrow("Planets")->AsList();
        UNIT_ASSERT_EQUAL(8, planets->GetChildCount());

        auto mercury = planets->GetChildOrThrow(0)->AsMap();
        UNIT_ASSERT_EQUAL(2439.7, mercury->GetChildOrThrow("Radius")->AsDouble()->GetValue());

        auto earth = planets->GetChildOrThrow(2)->AsMap();
        UNIT_ASSERT_EQUAL(7530000000, earth->GetChildOrThrow("Population")->AsUint64()->GetValue());
    }
}
