#pragma once

#include "serialize.h"

#include <yt/yt/core/ytree/yson_serializable.h>

namespace NCrypta::NYsonUtils {
    template<typename TYsonSerializableDerived>
    ::NYT::TIntrusivePtr<TYsonSerializableDerived> LoadFromYamlNode(const YAML::Node& yamlNode) {
        auto config = NYT::New<TYsonSerializableDerived>();
        const auto& node = NYT::NYTree::ConvertToNode(yamlNode);
        config->Load(node);
        return config;
    }

    template<typename TYsonSerializableDerived>
    ::NYT::TIntrusivePtr<TYsonSerializableDerived> LoadFromYamlStream(IInputStream& stream) {
        const auto node = YAML::Load(stream.ReadAll());
        return LoadFromYamlNode<TYsonSerializableDerived>(node);
    }

    template<typename TYsonSerializableDerived>
    ::NYT::TIntrusivePtr<TYsonSerializableDerived> LoadFromYamlFile(const TString& filename) {
        auto stream = TIFStream(filename);
        return LoadFromYamlStream<TYsonSerializableDerived>(stream);
    }
}
