#pragma once

#include "ydb_client.h"

#include <crypta/lib/native/ydb/proto/ydb_config.pb.h>

#include <ydb/public/sdk/cpp/client/ydb_driver/driver.h>
#include <ydb/public/sdk/cpp/client/ydb_table/table.h>
#include <library/cpp/threading/future/future.h>

#include <util/folder/pathsplit.h>
#include <util/stream/str.h>

namespace NCrypta {
    void ThrowOnError(const NYdb::TStatus& status, const TString& msg = "");

    template <typename T>
    void ThrowOnError(const TVector<NThreading::TFuture<T>>& futures, const TString& msg = "") {
        bool hasErrors = false;
        TStringStream stringStream;

        for (const auto& future : futures) {
            const auto& res = future.GetValue();
            if (!res.IsSuccess()) {
                res.GetIssues().PrintTo(stringStream);
                hasErrors = true;
            }
        }

        Y_ENSURE(!hasErrors, msg + ". Errors = " + stringStream.Str());
    }

    TVector<NYdb::NTable::TKeyRange> GetTableKeyRanges(NYdb::NTable::TSession& session, const TString& path);

    bool IsPathExists(NYdb::NScheme::TSchemeClient& schemeClient, const TString& path);

    TVector<NYdb::NScheme::TSchemeEntry> ListDirectory(NYdb::NScheme::TSchemeClient& schemeClient, const TString& path);

    void RemoveDirectory(NYdb::NTable::TTableClient& tableClient, NYdb::NScheme::TSchemeClient& schemeClient, const TString& path, bool recursive = false);

    TString GetFreshestTablePath(TYdbClient& ydbClient, const TString& directory);

    NYdb::TAsyncStatus CreateTable(TYdbClient& ydbClient, const TString& relativePath, NYdb::NTable::TTableDescription&& tableDescription, const NYdb::NTable::TCreateTableSettings& createTableSettings = NYdb::NTable::TCreateTableSettings());
    NYdb::TAsyncStatus DropTable(TYdbClient& ydbClient, const TString& relativePath, const NYdb::NTable::TDropTableSettings& dropTableSettings = NYdb::NTable::TDropTableSettings());
}
