#pragma once

#include <util/folder/pathsplit.h>

namespace NCrypta {
    namespace NImpl {
        inline void Append(TPathSplitUnix& prefix, TStringBuf component) {
            prefix.AppendComponent(component);
        }

        template <typename... TArgs>
        void Append(TPathSplitUnix& prefix, TStringBuf head, const TArgs&... tail) {
            prefix.AppendComponent(head);
            Append(prefix, tail...);
        }
    }

    template <typename... TArgs>
    TString JoinYdbPath(const TString& head, const TArgs&... tail) {
        TPathSplitUnix prefix(head);
        NImpl::Append(prefix, tail...);
        return prefix.Reconstruct();
    }
}
