#include "parse_utils.h"

using namespace NCrypta;

ui64 NYdbParseUtils::ParseUint64(const NYdb::TResultSet& resultSet, const TString& columnName) {
    NYdb::TResultSetParser parser(resultSet);
    Y_ENSURE(parser.TryNextRow(), "No result");
    ui64 result = parser.ColumnParser(columnName).GetUint64();
    Y_ENSURE(!parser.TryNextRow(), "Too many results");
    return result;
}

bool NYdbParseUtils::ParseBool(const NYdb::TResultSet& resultSet, const TString& columnName) {
    NYdb::TResultSetParser parser(resultSet);
    Y_ENSURE(parser.TryNextRow(), "No result");
    bool result = parser.ColumnParser(columnName).GetBool();
    Y_ENSURE(!parser.TryNextRow(), "Too many results");
    return result;
}
