#include "ydb_client.h"

#include "join.h"

using namespace NCrypta;
using namespace NYdb::NTable;

namespace {
    NYdb::TDriver CreateYdbDriver(const TYdbConfig& config) {
        const auto dbDriverConfig = NYdb::TDriverConfig()
            .SetEndpoint(config.GetEndpoint())
            .SetDatabase(config.GetDatabase())
            .SetAuthToken(config.GetToken());

        return NYdb::TDriver(dbDriverConfig);
    }
}

TYdbClient::TYdbClient(const TYdbConfig& config)
    : Driver(CreateYdbDriver(config))
    , Database(config.GetDatabase())
    , TableClient(Driver, TClientSettings().SessionPoolSettings(TSessionPoolSettings().MaxActiveSessions(config.GetMaxActiveSessions())))
    , SchemeClient(Driver)
{}

TString TYdbClient::GetAbsolutePath(const TString& relativePath) {
    return JoinYdbPath(Database, relativePath);
}
