#pragma once

#include <google/protobuf/message.h>
#include <library/cpp/protobuf/yql/descriptor.h>
#include <mapreduce/yt/interface/protobuf_format.h>
#include <util/generic/hash.h>

namespace NCrypta::NYqlProtoField {
    std::pair<TString, TString> GetAttr(const TString& field, const NProtoBuf::Descriptor* descriptor, const TProtoTypeConfigOptions& options = TProtoTypeConfigOptions());

    template <typename TMessage>
    std::pair<TString, TString> GetAttr(const TString& field, const TProtoTypeConfigOptions& options = TProtoTypeConfigOptions()) {
        return GetAttr(field, TMessage::descriptor(), options);
    }

    template <typename TMessage>
    THashMap<TString, TString> GetAttrs(const TProtoTypeConfigOptions& options = TProtoTypeConfigOptions()) {
        THashMap<TString, TString> attrs;

        const auto* descriptor = TMessage::descriptor();

        for (int i = 0; i < descriptor->field_count(); ++i) {
            const auto* fieldDescriptor = descriptor->field(i);
            const auto& fieldOptions = fieldDescriptor->options();

            if (!fieldDescriptor->message_type()
                || fieldDescriptor->is_repeated()
                || (NYT::NDetail::GetFieldOptions(fieldDescriptor).SerializationMode == NYT::NDetail::EProtobufSerializationMode::Yt)) {
                continue;
            }

            const auto& ytField = fieldOptions.HasExtension(NYT::column_name) ? fieldOptions.GetExtension(NYT::column_name) : fieldDescriptor->name();

            attrs.emplace(GetAttr(ytField, fieldDescriptor->message_type(), options));
        }

        return attrs;
    }
}
