#include "query_executer.h"

#include <util/string/split.h>
#include <util/system/env.h>

using namespace NCrypta::NYqlUtils;
using namespace NYql::NEmbedded;

namespace {
    TString GetShortYtProxyName(const TString& ytProxy) {
        return StringSplitter(ytProxy).Split('.').ToList<TString>().at(0);
    }

    static constexpr const char* LOCAL_YT_HOST_NAME = "local";
}

TQueryExecuter::TQueryExecuter(const TString& ytProxy, const TString& ytPool)
    : YtProxy(ytProxy)
    , YtPool(ytPool)
{
    TVector<TYtClusterOptions> ytClusters;

    const auto& localYtServer = GetEnv("LOCAL_YT_SERVER");
    if (!localYtServer.empty()) {
        YtProxy = LOCAL_YT_HOST_NAME;
        ytClusters = {{.Name_ = LOCAL_YT_HOST_NAME, .Cluster_ = localYtServer}};
    }

    OperationFactory = MakeOperationFactory({.YtClusters_ = ytClusters});
}

THolder<NYql::NEmbedded::IOperation> TQueryExecuter::Execute(const TString& query, const TQueryOptions& options) {
    return OperationFactory->Run(GetQuery(query, options), {.Title = options.Title_});
}

TString TQueryExecuter::GetQuery(const TString& baseQuery, const TQueryOptions& options) {
    auto resultQuery = TStringBuilder() << "USE " << GetShortYtProxyName(YtProxy) << ";\n"
                                        << "PRAGMA yt.Pool=\"" << YtPool << "\";\n";

    if (options.Tx_) {
        resultQuery << "PRAGMA yt.ExternalTx=\"" << GetGuidAsString(options.Tx_.GetRef()->GetId()) << "\";\n";
    }
    return resultQuery << baseQuery;
}
