#pragma once

#include <mapreduce/yt/interface/client.h>
#include <mapreduce/yt/interface/common.h>
#include <yql/library/embedded/yql_embedded.h>

#include <util/string/builder.h>

namespace NCrypta::NYqlUtils {
    struct TQueryOptions {
        using TSelf = TQueryOptions;

        FLUENT_FIELD(TString, Title);
        FLUENT_FIELD_OPTION(NYT::ITransactionPtr, Tx);
    };

    class TQueryExecuter {
    public:
        TQueryExecuter(const TString& ytProxy, const TString& ytPool);

        THolder<NYql::NEmbedded::IOperation> Execute(const TString& query, const TQueryOptions& options);

    private:
        TString GetQuery(const TString& query, const TQueryOptions& options);

        THolder<NYql::NEmbedded::IOperationFactory> OperationFactory;
        TString YtProxy;
        TString YtPool;
    };
}