#pragma once

#include <crypta/lib/native/database/record.h>
#include <crypta/lib/native/yt/dyntables/async_database/proto/client_config.pb.h>
#include <crypta/lib/native/yt/dyntables/async_database/proto/modify_rows_config.pb.h>
#include <crypta/lib/native/yt/dyntables/async_database/proto/table_config.pb.h>
#include <crypta/lib/native/yt/dyntables/kv_schema/unversioned_row_parser.h>

#include <yt/yt/client/api/client.h>
#include <yt/yt/client/api/public.h>
#include <yt/yt/client/api/transaction.h>
#include <yt/yt/core/actions/future.h>
#include <util/generic/ptr.h>
#include <util/generic/vector.h>

namespace NCrypta::NYtDynTables {
    class TKvAsyncDatabaseTransaction;
    using TKvAsyncDatabaseTransactionPtr = TAtomicSharedPtr<TKvAsyncDatabaseTransaction>;

    class TKvAsyncDatabase {
    public:
        TKvAsyncDatabase(const TClientConfig& clientConfig,
                         const TTableConfig& tableConfig,
                         const TModifyRowsConfig& modifyRowsConfig);

        virtual ~TKvAsyncDatabase() = default;

    protected:
        TKvAsyncDatabase(NYT::NApi::IClientBasePtr client,
                    const TKvAsyncDatabase& parent);

    public:
        NYT::TFuture<TKvAsyncDatabaseTransactionPtr> StartTransaction();
        NYT::TFuture<TVector<TRecord>> Lookup(const TVector<TString>& keys);

    private:
        TVector<TRecord> ParseRecords(const NYT::NApi::IUnversionedRowsetPtr& rowset);

    protected:
        TString TablePath;
        NYT::NApi::TModifyRowsOptions ModifyRowsConfig;
        TDuration OperationTimeout;
        NYT::NApi::IClientBasePtr Client;
        const TUnversionedRowParser RowParser;
    };

    class TKvAsyncDatabaseTransaction : public TKvAsyncDatabase {
    public:
        TKvAsyncDatabaseTransaction(const NYT::NApi::ITransactionPtr& tx, const TKvAsyncDatabase& parent);

        void Write(const TVector<TRecord>& records);
        void Delete(const TVector<TString>& keys);
        NYT::TFuture<NYT::NApi::TTransactionCommitResult> Commit();
        NYT::TFuture<void> Abort();

    private:
        NYT::NApi::ITransactionPtr Tx;
    };
}
