#pragma once

#include <crypta/lib/native/stats/stats.h>
#include <crypta/lib/native/yt/dyntables/async_database/kv_async_database.h>

namespace NCrypta::NYtDynTables {
    using TKvAsyncDatabasePtr = TAtomicSharedPtr<TKvAsyncDatabase>;

    class TKvDatabaseTransaction;
    using TKvDatabaseTransactionPtr = TAtomicSharedPtr<TKvDatabaseTransaction>;

    class TKvDatabase {
    public:
        TKvDatabase(TKvAsyncDatabasePtr mainDatabase, TStats& stats, TVector<TKvAsyncDatabasePtr> retryDatabases = {}, TDuration retryTimeout = TDuration::Zero());
        virtual ~TKvDatabase() = default;

    public:
        TKvDatabaseTransactionPtr StartTransaction();
        TVector<TRecord> Lookup(const TVector<TString>& keys);

    protected:
        TKvAsyncDatabasePtr MainDatabase;
        TVector<TKvAsyncDatabasePtr> RetryDatabases;
        TDuration RetryTimeout;

        TStats& Stats;
    };

    class TKvDatabaseTransaction : public TKvDatabase {
    public:
        TKvDatabaseTransaction(TKvAsyncDatabaseTransactionPtr asyncTx, TStats& stats);

        void Write(const TVector<TRecord>& records);
        void Delete(const TVector<TString>& keys);
        NYT::NApi::TTransactionCommitResult Commit();
        void Abort();

    private:
        TKvAsyncDatabaseTransactionPtr AsyncTx;
    };
}
