#include "logger.h"

#include <yt/yt/core/logging/config.h>
#include <yt/yt/core/logging/log_manager.h>

using namespace NCrypta::NYtDynTables;

void NLogger::Configure(const TLoggerConfig& config) {
    auto rule = NYT::New<NYT::NLogging::TRuleConfig>();
    rule->Writers = {config.GetWriterName()};
    rule->MinLevel = NYT::TEnumTraits<NYT::NLogging::ELogLevel>::FromString(config.GetLogLevel());

    auto writer = NYT::New<NYT::NLogging::TLogWriterConfig>();
    writer->Type = NYT::NLogging::TFileLogWriterConfig::Type;

    auto fileWriter = NYT::New<NYT::NLogging::TFileLogWriterConfig>();
    fileWriter->FileName = config.GetFileName();

    auto logConfig = NYT::New<NYT::NLogging::TLogManagerConfig>();
    logConfig->Rules = {rule};
    logConfig->Writers = {{config.GetWriterName(), writer->BuildFullConfig(fileWriter)}};

    NYT::NLogging::TLogManager::Get()->Configure(logConfig);
}
