#include "yt_exception.h"

using namespace NCrypta::NYtDynTables;

TYtException::TYtException(NYT::TError error)
    : Error(std::move(error)) {
}

const NYT::TError& TYtException::GetError() const {
    return Error;
}

const char* TYtException::what() const noexcept {
    if (Message.empty()) {
        Message = yexception::what() + ToString(Error);
    }
    return Message.data();
}
