#include "subsystems_config.h"

#include <yt/yt/core/logging/config.h>
#include <yt/yt/core/logging/log_manager.h>
#include <yt/yt/core/net/address.h>
#include <yt/yt/core/net/dns_resolver.h>
#include <yt/yt/core/rpc/dispatcher.h>
#include <yt/yt/core/yson/writer.h>
#include <yt/yt/client/api/rpc_proxy/config.h>
#include <yt/yt/client/api/rpc_proxy/connection.h>

namespace NCrypta {
    using namespace NYT::NApi;
    using namespace NYT::NYTree;
    using namespace NYT::NApi::NRpcProxy;
    using namespace NYT::NTableClient;

    TYtSubsystemsConfig::TYtSubsystemsConfig() {
        RegisterParameter("address_resolver", AddressResolver).DefaultNew();
        RegisterParameter("rpc_dispatcher", RpcDispatcher).DefaultNew();
        RegisterParameter("logging", Logging).Default(NYT::NLogging::TLogManagerConfig::CreateDefault());
    }

    void TYtSubsystemsConfig::InitializeSubsystems() {
        NYT::NLogging::TLogManager::Get()->Configure(Logging);

        NYT::NNet::TAddressResolver::Get()->Configure(AddressResolver);

        NYT::NRpc::TDispatcher::Get()->Configure(RpcDispatcher);
    }
}
