#pragma once

#include <yt/yt/core/logging/config.h>
#include <yt/yt/core/misc/intrusive_ptr.h>
#include <yt/yt/core/net/dns_resolver.h>
#include <yt/yt/client/api/rpc_proxy/connection.h>

namespace NCrypta {
    class TYtSubsystemsConfig : public NYT::NYTree::TYsonSerializable {
    public:
        NYT::NNet::TAddressResolverConfigPtr AddressResolver;
        NYT::NRpc::TDispatcherConfigPtr RpcDispatcher;
        NYT::NLogging::TLogManagerConfigPtr Logging;

        TYtSubsystemsConfig();

        void InitializeSubsystems();
    };

    using TYtSubsystemsConfigPtr = NYT::TIntrusivePtr<TYtSubsystemsConfig>;

} // namespace NCrypta
