#include "key_value_rows_builder.h"

#include "fields.h"

using namespace NCrypta::NYtDynTables;

TKeyValueRowsBuilder& TKeyValueRowsBuilder::AddRow(const TString& key, const TString& value) {
    Builder.AddValue(NYT::NTableClient::MakeUnversionedStringValue(key, EKvSchemaId::Key));
    Builder.AddValue(NYT::NTableClient::MakeUnversionedStringValue(value, EKvSchemaId::Value));
    Rows.emplace_back(RowBuffer->CaptureRow(Builder.FinishRow()));
    return *this;
}
