#include "kv_schema.h"

#include "fields.h"

#include <yt/yt/core/ytree/convert.h>
#include <yt/yt/client/table_client/comparator.h>
#include <yt/yt/client/table_client/logical_type.h>

#include <util/string/builder.h>

using namespace NYT::NTableClient;

namespace {
    std::vector<TColumnSchema> GetColumns() {
        using namespace NCrypta::NYtDynTables::NFields;
        using namespace NCrypta::NYtDynTables;

        TColumnSchema hashColumn(HASH, EValueType::Uint64, ESortOrder::Ascending);
        auto expression = TStringBuilder() << "farm_hash(" << KEY << ")";
        hashColumn.SetExpression(expression);

        TColumnSchema keyColumn(KEY, SimpleLogicalType(ESimpleLogicalValueType::String), ESortOrder::Ascending);

        TColumnSchema valueColumn(VALUE, OptionalLogicalType(SimpleLogicalType(ESimpleLogicalValueType::String)));

        std::vector<TColumnSchema> columns(3);
        columns[EKvSchemaId::Hash] = hashColumn;
        columns[EKvSchemaId::Key] = keyColumn;
        columns[EKvSchemaId::Value] = valueColumn;

        return columns;
    }

    constexpr bool STRICT = true;
    constexpr bool UNIQUE_KEYS = true;
}

namespace NCrypta::NYtDynTables {
    NYT::NTableClient::TTableSchema MakeKvSchema() {
        return NYT::NTableClient::TTableSchema(
            GetColumns(),
            STRICT,
            UNIQUE_KEYS);
    }

    TString SchemaToYsonString(const NYT::NTableClient::TTableSchema& schema) {
        return NYT::NYson::ConvertToYsonString(schema).ToString();
    }
}
