#include "prepared_rows_builder.h"

#include "fields.h"
#include "kv_schema.h"

#include <util/generic/maybe.h>
#include <util/generic/vector.h>

using namespace NCrypta::NYtDynTables;

TPreparedRowsBuilder::TPreparedRowsBuilder() {
    Clear();
}

void TPreparedRowsBuilder::Clear() {
    RowBuffer = NYT::New<NYT::NTableClient::TRowBuffer>();
    Rows = TRows();
}

TPreparedRows TPreparedRowsBuilder::Build() {
    TPreparedRows result;
    result.NameTable = NYT::NTableClient::TNameTable::FromSchema(KvSchema);
    result.Rows = NYT::MakeSharedRange(std::move(Rows), RowBuffer);

    Clear();

    return result;
}

ui64 TPreparedRowsBuilder::Size() const {
    return Rows.size();
}
