#pragma once

#include "prepared_rows.h"

#include "kv_schema.h"

#include <crypta/lib/native/database/record.h>

#include <yt/yt/client/table_client/unversioned_row.h>

#include <util/generic/maybe.h>
#include <util/generic/vector.h>

namespace NCrypta::NYtDynTables {
    class TPreparedRowsBuilder {
    public:
        TPreparedRowsBuilder();
        TPreparedRows Build();
        ui64 Size() const;

    protected:
        using TRows = TVector<NYT::NTableClient::TUnversionedRow>;

        const NYT::NTableClient::TTableSchema KvSchema = MakeKvSchema();
        NYT::NTableClient::TUnversionedOwningRowBuilder Builder;
        NYT::NTableClient::TRowBufferPtr RowBuffer;
        TRows Rows;

    private:
        void Clear();
    };
}
