#include "row_parser_base.h"

#include <yt/yt/client/table_client/unversioned_row.h>

#include <util/generic/maybe.h>

using namespace NCrypta::NYtDynTables;
using namespace NYT::NTableClient;


void TRowParserBase::ValidateValueType(const NYT::NTableClient::TUnversionedValue& value) const {
    NYT::NTableClient::ValidateValueType(value, KvSchema.Columns().at(value.Id), false);
}

void TRowParserBase::EnsureFieldsSet(const TMaybe<TString>& key, const TMaybe<TString>& value) {
    Y_ENSURE((key.Defined() && value.Defined()), "Key or/and value is not defined");
}
