#include "unversioned_row_parser.h"

#include <yt/yt/client/table_client/unversioned_row.h>

using namespace NCrypta;
using namespace NYT::NTableClient;

namespace {
    void FillStringField(TMaybe<TString>& field, const TUnversionedValue& value) {
        Y_ENSURE(!field.Defined(), "Duplicate field found");
        field = value.AsString();
    }
}

TRecord NYtDynTables::TUnversionedRowParser::Parse(const TUnversionedRow& row) const {
    TMaybe<TString> key;
    TMaybe<TString> value;

    for (const auto& unversionedValue : row) {
        ValidateValueType(unversionedValue);
        const auto& id = unversionedValue.Id;
        switch (id) {
            case EKvSchemaId::Key:
                FillStringField(key, unversionedValue);
                break;
            case EKvSchemaId::Value:
                FillStringField(value, unversionedValue);
                break;
            case EKvSchemaId::Hash:
                break;
            default:
                ythrow yexception() << "Unknown id in row: " << id;
        }
    }

    EnsureFieldsSet(key, value);
    return {.Key = std::move(*key), .Value = std::move(*value)};
}
