#include "versioned_row_parser.h"

#include <yt/yt/client/table_client/versioned_row.h>

using namespace NCrypta::NYtDynTables;
using namespace NYT::NTableClient;


NCrypta::TRecord TVersionedRowParser::Parse(const TVersionedRow& row) const {
    TMaybe<TString> key;
    TMaybe<TString> value;

    for (auto iter = row.BeginKeys(); iter != row.EndKeys(); ++iter) {
        ValidateValueType(*iter);
        HandleRowKey(*iter, key);
    }

    for (auto iter = row.BeginValues(); iter != row.EndValues(); ++iter) {
        ValidateValueType(*iter);
        HandleRowValue(*iter, value);
    }

    EnsureFieldsSet(key, value);
    return NCrypta::TRecord{.Key = std::move(*key), .Value = std::move(*value)};
}

void TVersionedRowParser::HandleRowKey(const NYT::NTableClient::TUnversionedValue& unversionedValue, TMaybe<TString>& key) const {
    const auto& id = unversionedValue.Id;
    switch (id) {
        case EKvSchemaId::Key:
            Y_ENSURE(!key.Defined(), "Duplicate key found");
            key = unversionedValue.AsString();
            break;
        case EKvSchemaId::Hash:
            break;
        default:
            ythrow yexception() << "Unknown field in keys, id = " << id;
    }
}

void TVersionedRowParser::HandleRowValue(const NYT::NTableClient::TVersionedValue& versionedValue, TMaybe<TString>& value) const {
    const auto& id = versionedValue.Id;
    if (id == EKvSchemaId::Value) {
        if (!value.Defined()) {
            value = versionedValue.AsString();
        }
    } else {
        ythrow yexception() << "Unknown field in values, id = " << id;
    }
}
