#include "retrying_client.h"

#include <yt/yt/client/table_client/unversioned_row.h>
#include <yt/yt/client/ypath/rich.h>

using namespace NYT;
using namespace NYT::NApi;
using namespace NCrypta::NYtDynTables;

TRetryingClient::TRetryingClient(TVector<IClientBasePtr> clients, TDuration retryTimeout)
    : Clients(std::move(clients))
    , RetryTimeout(retryTimeout)
{
    Y_ENSURE(!Clients.empty(), "Clients should not be empty");
    Cerr << "TRetryableClient with " << Clients.size() << " clients" << Endl;
}

IConnectionPtr TRetryingClient::GetConnection() {
    return Clients[0]->GetConnection();
}

TFuture<ITransactionPtr> TRetryingClient::StartTransaction(NTransactionClient::ETransactionType type, const TTransactionStartOptions& options) {
    return DoWithRetries<ITransactionPtr>([=](IClientBasePtr client) { return client->StartTransaction(type, options); });
}

TFuture<IUnversionedRowsetPtr> TRetryingClient::LookupRows(const NYPath::TYPath& path, NTableClient::TNameTablePtr nameTable, const TSharedRange<NTableClient::TUnversionedRow>& keys, const TLookupRowsOptions& options) {
    return DoWithRetries<IUnversionedRowsetPtr>([=](IClientBasePtr client) { return client->LookupRows(path, nameTable, keys, options); });
}

TFuture<IVersionedRowsetPtr> TRetryingClient::VersionedLookupRows(const NYPath::TYPath& path, NTableClient::TNameTablePtr nameTable, const TSharedRange<NTableClient::TUnversionedRow>& keys, const TVersionedLookupRowsOptions& options) {
    return DoWithRetries<IVersionedRowsetPtr>([=](IClientBasePtr client) { return client->VersionedLookupRows(path, nameTable, keys, options); });
}

TFuture<TSelectRowsResult> TRetryingClient::SelectRows(const TString& query, const TSelectRowsOptions& options) {
    return DoWithRetries<TSelectRowsResult>([=](IClientBasePtr client) { return client->SelectRows(query, options); });
}

TFuture<ITableReaderPtr> TRetryingClient::CreateTableReader(const NYPath::TRichYPath& path, const TTableReaderOptions& options) {
    return DoWithRetries<ITableReaderPtr>([=](IClientBasePtr client) { return client->CreateTableReader(path, options); });
}

TFuture<ITableWriterPtr> TRetryingClient::CreateTableWriter(const NYPath::TRichYPath& path, const TTableWriterOptions& options) {
    return DoWithRetries<ITableWriterPtr>([=](IClientBasePtr client) { return client->CreateTableWriter(path, options); });
}

TFuture<NYT::NYson::TYsonString> TRetryingClient::GetNode(const NYPath::TYPath& path, const TGetNodeOptions& options) {
    return DoWithRetries<NYT::NYson::TYsonString>([=](IClientBasePtr client) { return client->GetNode(path, options); });
}

TFuture<void> TRetryingClient::SetNode(const NYPath::TYPath& path, const NYT::NYson::TYsonString& value, const TSetNodeOptions& options) {
    return DoWithRetries<void>([=](IClientBasePtr client) { return client->SetNode(path, value, options); });
}

TFuture<void> TRetryingClient::RemoveNode(const NYPath::TYPath& path, const TRemoveNodeOptions& options) {
    return DoWithRetries<void>([=](IClientBasePtr client) { return client->RemoveNode(path, options); });
}

TFuture<NYT::NYson::TYsonString> TRetryingClient::ListNode(const NYPath::TYPath& path, const TListNodeOptions& options) {
    return DoWithRetries<NYT::NYson::TYsonString>([=](IClientBasePtr client) { return client->ListNode(path, options); });
}

TFuture<NCypressClient::TNodeId> TRetryingClient::CreateNode(const NYPath::TYPath& path, NObjectClient::EObjectType type, const TCreateNodeOptions& options) {
    return DoWithRetries<NCypressClient::TNodeId>([=](IClientBasePtr client) { return client->CreateNode(path, type, options); });
}

TFuture<TLockNodeResult> TRetryingClient::LockNode(const NYPath::TYPath& path, NCypressClient::ELockMode mode, const TLockNodeOptions& options) {
    return DoWithRetries<TLockNodeResult>([=](IClientBasePtr client) { return client->LockNode(path, mode, options); });
}

TFuture<void> TRetryingClient::UnlockNode(const NYPath::TYPath& path, const TUnlockNodeOptions& options) {
    return DoWithRetries<void>([=](IClientBasePtr client) { return client->UnlockNode(path, options); });
}

TFuture<NCypressClient::TNodeId> TRetryingClient::CopyNode(const NYPath::TYPath& srcPath, const NYPath::TYPath& dstPath, const TCopyNodeOptions& options) {
    return DoWithRetries<NCypressClient::TNodeId>([=](IClientBasePtr client) { return client->CopyNode(srcPath, dstPath, options); });
}

TFuture<NCypressClient::TNodeId> TRetryingClient::MoveNode(const NYPath::TYPath& srcPath, const NYPath::TYPath& dstPath, const TMoveNodeOptions& options) {
    return DoWithRetries<NCypressClient::TNodeId>([=](IClientBasePtr client) { return client->MoveNode(srcPath, dstPath, options); });
}

TFuture<NCypressClient::TNodeId> TRetryingClient::LinkNode(const NYPath::TYPath& srcPath, const NYPath::TYPath& dstPath, const TLinkNodeOptions& options) {
    return DoWithRetries<NCypressClient::TNodeId>([=](IClientBasePtr client) { return client->LinkNode(srcPath, dstPath, options); });
}

TFuture<void> TRetryingClient::ConcatenateNodes(const std::vector<NYPath::TRichYPath>& srcPaths, const NYPath::TRichYPath& dstPath, const TConcatenateNodesOptions& options) {
    return DoWithRetries<void>([=](IClientBasePtr client) { return client->ConcatenateNodes(srcPaths, dstPath, options); });
}

TFuture<bool> TRetryingClient::NodeExists(const NYPath::TYPath& path, const TNodeExistsOptions& options) {
    return DoWithRetries<bool>([=](IClientBasePtr client) { return client->NodeExists(path, options); });
}

TFuture<void> TRetryingClient::ExternalizeNode(const NYPath::TYPath& path, NObjectClient::TCellTag cellTag, const TExternalizeNodeOptions& options) {
    return DoWithRetries<void>([=](IClientBasePtr client) { return client->ExternalizeNode(path, cellTag, options); });
}

TFuture<void> TRetryingClient::InternalizeNode(const NYPath::TYPath& path, const TInternalizeNodeOptions& options) {
    return DoWithRetries<void>([=](IClientBasePtr client) { return client->InternalizeNode(path, options); });
}

TFuture<NObjectClient::TObjectId> TRetryingClient::CreateObject(NObjectClient::EObjectType type, const TCreateObjectOptions& options) {
    return DoWithRetries<NObjectClient::TObjectId>([=](IClientBasePtr client) { return client->CreateObject(type, options); });
}

TFuture<IFileReaderPtr> TRetryingClient::CreateFileReader(const NYPath::TYPath& path, const TFileReaderOptions& options) {
    return DoWithRetries<IFileReaderPtr>([=](IClientBasePtr client) { return client->CreateFileReader(path, options); });
}

IFileWriterPtr TRetryingClient::CreateFileWriter(const NYPath::TRichYPath& path, const TFileWriterOptions& options) {
    return Clients[0]->CreateFileWriter(path, options);
}

IJournalReaderPtr TRetryingClient::CreateJournalReader(const NYPath::TYPath& path, const TJournalReaderOptions& options) {
    return Clients[0]->CreateJournalReader(path, options);
}

IJournalWriterPtr TRetryingClient::CreateJournalWriter(const NYPath::TYPath& path, const TJournalWriterOptions& options) {
    return Clients[0]->CreateJournalWriter(path, options);
}
