#pragma once

#include <yt/yt/client/api/client.h>

#include <util/datetime/base.h>
#include <util/generic/vector.h>

namespace NCrypta::NYtDynTables {
    class TRetryingClient : public NYT::NApi::IClientBase {
    public:
        TRetryingClient(TVector<NYT::NApi::IClientBasePtr> clients, TDuration retryTimeout);

        NYT::NApi::IConnectionPtr GetConnection() override;
        NYT::TFuture<NYT::NApi::ITransactionPtr> StartTransaction(NYT::NTransactionClient::ETransactionType type, const NYT::NApi::TTransactionStartOptions& options) override;
        NYT::TFuture<NYT::NApi::IUnversionedRowsetPtr> LookupRows(const NYT::NYPath::TYPath& path, NYT::NTableClient::TNameTablePtr nameTable, const NYT::TSharedRange<NYT::NTableClient::TUnversionedRow>& keys,
                                                                  const NYT::NApi::TLookupRowsOptions& options) override;

        NYT::TFuture<NYT::NApi::IVersionedRowsetPtr>
        VersionedLookupRows(const NYT::NYPath::TYPath& path, NYT::NTableClient::TNameTablePtr nameTable, const NYT::TSharedRange<NYT::NTableClient::TUnversionedRow>& keys,
                            const NYT::NApi::TVersionedLookupRowsOptions& options) override;

        NYT::TFuture<NYT::NApi::TSelectRowsResult> SelectRows(const TString& query, const NYT::NApi::TSelectRowsOptions& options) override;
        NYT::TFuture<NYT::NApi::ITableReaderPtr> CreateTableReader(const NYT::NYPath::TRichYPath& path, const NYT::NApi::TTableReaderOptions& options) override;
        NYT::TFuture<NYT::NApi::ITableWriterPtr> CreateTableWriter(const NYT::NYPath::TRichYPath& path, const NYT::NApi::TTableWriterOptions& options) override;
        NYT::TFuture<NYT::NYson::TYsonString> GetNode(const NYT::NYPath::TYPath& path, const NYT::NApi::TGetNodeOptions& options) override;
        NYT::TFuture<void> SetNode(const NYT::NYPath::TYPath& path, const NYT::NYson::TYsonString& value, const NYT::NApi::TSetNodeOptions& options) override;
        NYT::TFuture<void> RemoveNode(const NYT::NYPath::TYPath& path, const NYT::NApi::TRemoveNodeOptions& options) override;
        NYT::TFuture<NYT::NYson::TYsonString> ListNode(const NYT::NYPath::TYPath& path, const NYT::NApi::TListNodeOptions& options) override;
        NYT::TFuture<NYT::NCypressClient::TNodeId> CreateNode(const NYT::NYPath::TYPath& path, NYT::NObjectClient::EObjectType type, const NYT::NApi::TCreateNodeOptions& options) override;
        NYT::TFuture<NYT::NApi::TLockNodeResult> LockNode(const NYT::NYPath::TYPath& path, NYT::NCypressClient::ELockMode mode, const NYT::NApi::TLockNodeOptions& options) override;
        NYT::TFuture<void> UnlockNode(const NYT::NYPath::TYPath& path, const NYT::NApi::TUnlockNodeOptions& options) override;
        NYT::TFuture<NYT::NCypressClient::TNodeId> CopyNode(const NYT::NYPath::TYPath& srcPath, const NYT::NYPath::TYPath& dstPath, const NYT::NApi::TCopyNodeOptions& options) override;
        NYT::TFuture<NYT::NCypressClient::TNodeId> MoveNode(const NYT::NYPath::TYPath& srcPath, const NYT::NYPath::TYPath& dstPath, const NYT::NApi::TMoveNodeOptions& options) override;
        NYT::TFuture<NYT::NCypressClient::TNodeId> LinkNode(const NYT::NYPath::TYPath& srcPath, const NYT::NYPath::TYPath& dstPath, const NYT::NApi::TLinkNodeOptions& options) override;
        NYT::TFuture<void> ConcatenateNodes(const std::vector<NYT::NYPath::TRichYPath>& srcPaths, const NYT::NYPath::TRichYPath& dstPath, const NYT::NApi::TConcatenateNodesOptions& options) override;
        NYT::TFuture<bool> NodeExists(const NYT::NYPath::TYPath& path, const NYT::NApi::TNodeExistsOptions& options) override;
        NYT::TFuture<void> ExternalizeNode(const NYT::NYPath::TYPath& path, NYT::NObjectClient::TCellTag cellTag, const NYT::NApi::TExternalizeNodeOptions& options) override;
        NYT::TFuture<void> InternalizeNode(const NYT::NYPath::TYPath& path, const NYT::NApi::TInternalizeNodeOptions& options) override;
        NYT::TFuture<NYT::NObjectClient::TObjectId> CreateObject(NYT::NObjectClient::EObjectType type, const NYT::NApi::TCreateObjectOptions& options) override;
        NYT::TFuture<NYT::NApi::IFileReaderPtr> CreateFileReader(const NYT::NYPath::TYPath& path, const NYT::NApi::TFileReaderOptions& options) override;
        NYT::NApi::IFileWriterPtr CreateFileWriter(const NYT::NYPath::TRichYPath& path, const NYT::NApi::TFileWriterOptions& options) override;
        NYT::NApi::IJournalReaderPtr CreateJournalReader(const NYT::NYPath::TYPath& path, const NYT::NApi::TJournalReaderOptions& options) override;
        NYT::NApi::IJournalWriterPtr CreateJournalWriter(const NYT::NYPath::TYPath& path, const NYT::NApi::TJournalWriterOptions& options) override;

    private:
        template <typename T>
        NYT::TFuture<T> DoWithRetries(std::function<NYT::TFuture<T>(NYT::NApi::IClientBasePtr)> func) {
            TVector<NYT::TFuture<T>> futures = { func(this->Clients[0]) };

            for (size_t i = 1; i < this->Clients.size(); i++) {
                futures.push_back(
                    NYT::NConcurrency::TDelayedExecutor::MakeDelayed(this->RetryTimeout).Apply(BIND([=]() { return func(this->Clients[i]); }))
                );
            }

            return NYT::AnySucceeded(std::move(futures));
        }

        TVector<NYT::NApi::IClientBasePtr> Clients;
        const TDuration RetryTimeout;
    };
}
