#include "yaml_config_utils.h"

#include <crypta/lib/native/yaml/parse_yaml_file.h>

#include <library/cpp/getopt/small/last_getopt.h>

#include <util/stream/file.h>

YAML::Node NCrypta::ParseYamlConfig(int argc, const char** argv, const TString& configArgName) {
    TString configPath;
    NLastGetopt::TOpts opts = NLastGetopt::TOpts::Default();
    opts.AddHelpOption();
    opts.AddLongOption(configArgName).StoreResult(&configPath).RequiredArgument("CONFIG PATH").Required();
    NLastGetopt::TOptsParseResult optsParseResult(&opts, argc, argv);

    return ParseYamlFile(configPath);
}
