#include "tx_pinger.h"

namespace NCrypta {
    TTransactionPinger::TTransactionPinger(NYT::ITransactionPtr tx, TThreaded::TOnFinishHandler callBack)
        : Tx(tx)
    {
        SetOnFinishHandler(callBack);
    }

    TTransactionPinger::~TTransactionPinger() {
        Stop();
        Wake.Signal();
        Join();
    }

    NYT::ITransactionPtr TTransactionPinger::GetTx() {
        return Tx;
    }

    void TTransactionPinger::Run() {
        try {
            while(IsRunning()) {
                Tx->Ping();
                Wake.WaitT(PING_INTERVAL);
            }
        } catch(const std::exception&) {
            ;
        }
    }
}
