#pragma once
#include <crypta/lib/native/thread/threaded.h>
#include <mapreduce/yt/interface/client.h>
#include <util/system/event.h>

namespace NCrypta {
    class TTransactionPinger : public TThreaded {
    public:
        TTransactionPinger(NYT::ITransactionPtr tx, TThreaded::TOnFinishHandler callBack);
        ~TTransactionPinger();

        NYT::ITransactionPtr GetTx();
    private:
        void Run() override;
        NYT::ITransactionPtr Tx;
        TManualEvent Wake;
        static constexpr TDuration PING_INTERVAL{TDuration::Seconds(10)};
    };
}
