#include "parse_log_job_config.h"

#include <crypta/lib/native/yt/utils/yt_params.h>

namespace {
    const char* const PARAM_PROCESSED_STATE_TABLE = "processed-state-table";
    const char* const PARAM_MAX_TABLES_OT_PROCESS = "max-tables-to-process";
}

namespace NCrypta {
    TParseLogJobConfig::TParseLogJobConfig() {
        Param(ProcessedTablesConfig.SourceDir, PARAM_SRC).Help("source dir");
        Param(ProcessedTablesConfig.StateTable, PARAM_PROCESSED_STATE_TABLE).Help("processed state table");

        Param(MaxTablesToProcess, PARAM_MAX_TABLES_OT_PROCESS).Help("max tables to process").Optional().DefaultValue(50);
    }
}
