#pragma once

#include <crypta/lib/native/yt/processed_tables_tracker/proto/tracked_source.pb.h>
#include <crypta/lib/native/yt/utils/helpers.h>

#include <mapreduce/yt/interface/client.h>

#include <util/generic/hash_set.h>
#include <util/generic/set.h>

namespace NCrypta {
    class TProcessedTablesTracker {
    public:
        struct TConfig {
            NYT::TYPath SourceDir;
            NYT::TYPath StateTable;
        };

        explicit TProcessedTablesTracker(const TConfig& options);
        explicit TProcessedTablesTracker(const TTrackedSource& trackedSource);

        TVector<NYT::TYPath> GetUnprocessedTables(NYT::IClientBasePtr client, ui32 maxTables = std::numeric_limits<ui32>::max());

        template <typename TContainer>
        void AddProcessedTables(NYT::IClientBasePtr client, const TContainer& newTables) {
            auto processedTables = GetProcessedTables(client);
            const auto& allTables = GetAllTables(client);

            processedTables.insert(newTables.begin(), newTables.end());

            auto writer = client->CreateTableWriter<NYT::TNode>(Config.StateTable);

            for (const auto& path: processedTables) {
                if (!allTables.contains(path)) {
                    continue;
                }

                writer->AddRow(NYT::TNode()(TABLE, path));
            }

            writer->Finish();

            SetAttribute(client, Config.StateTable, SOURCE_DIR_ATTRIBUTE, Config.SourceDir);
        }

    private:
        const TConfig Config;

        static const TString SOURCE_DIR_ATTRIBUTE;
        static const TString TABLE;

        THashSet<NYT::TYPath> GetProcessedTables(NYT::IClientBasePtr client);
        THashSet<NYT::TYPath> GetAllTables(NYT::IClientBasePtr client);
    };
}
