#pragma once

#include <library/cpp/getopt/small/last_getopt.h>

namespace NCrypta {
    class TConfigParser {
    protected:
        template <typename T>
        NLastGetopt::TOpt& Param(T& dst, TString name) {
            auto& opt = Opts.AddLongOption(name).Required();

            Bindings.push_back([&dst, name](NLastGetopt::TOptsParseResult& opr) {
                if (!opr.Has(name, true)) {
                    return;
                }

                dst = opr.Get<T>(name);
            });

            Printers.push_back([&dst, name]() {
                return name + "=" + ToString(dst);
            });

            return opt;
        }

        template <typename T>
        NLastGetopt::TOpt& Param(TMaybe<T>& dst, TString name) {
            auto& opt = Opts.AddLongOption(name).Optional();

            Bindings.push_back([&dst, name](NLastGetopt::TOptsParseResult& opr) {
                if (!opr.Has(name, true)) {
                    return;
                }

                dst = opr.Get<T>(name);
            });

            Printers.push_back([&dst, name]() {
                return name + "=" + (dst ? ToString(*dst) : "");
            });

            return opt;
        }

        void Parse(int argc, const char** argv) {
            NLastGetopt::TOptsParseResult optsParseResult(&Opts, argc, argv);
            for (auto binding : Bindings) {
                binding(optsParseResult);
            }
        }

    public:
        void Print() {
            for (auto printer : Printers) {
                Cout << printer() << Endl;
            }
        }

    private:
        NLastGetopt::TOpts Opts;
        TVector<std::function<void(NLastGetopt::TOptsParseResult&)>> Bindings;
        TVector<std::function<TString()>> Printers;
    };

} // NCrypta
