#include "error_utils.h"

#include <util/generic/hash.h>
#include <util/string/cast.h>

using namespace NCrypta;

namespace {
    static const THashMap<int, TString> ERROR_CODE_TO_STRING = {
            { 0, "ok" },
            { 1, "generic" },
            { 2, "canceled" },
            { 3, "timeout" },
            { 4, "future_combiner_failure" },
            { 5, "future_combiner_shortcut" },
            { 100, "transport_error" },
            { 101, "protocol_error" },
            { 102, "no_such_service" },
            { 103, "no_such_method" },
            { 105, "unavailable" },
            { 106, "poison_pill" },
            { 108, "rpc_request_queue_size_limit_exceeded" },
            { 109, "rpc_authentication_error" },
            { 110, "invalid_csrf_token" },
            { 111, "invalid_credentials" },
            { 200, "no_such_operation" },
            { 201, "invalid_operation_state" },
            { 202, "too_many_operations" },
            { 203, "no_such_job" },
            { 210, "operation_failed_on_job_restart" },
            { 301, "sort_order_violation" },
            { 302, "invalid_double_value" },
            { 303, "incomparable_type" },
            { 304, "unhashable_type" },
            { 305, "corrupted_name_table" },
            { 306, "unique_key_violation" },
            { 307, "schema_violation" },
            { 308, "row_weight_limit_exceeded" },
            { 309, "invalid_column_filter" },
            { 310, "invalid_column_renaming" },
            { 311, "incompatible_key_columns" },
            { 312, "reader_deadline_expired" },
            { 400, "same_transaction_lock_conflict" },
            { 401, "descendant_transaction_lock_conflict" },
            { 402, "concurrent_transaction_lock_conflict" },
            { 403, "pending_lock_conflict" },
            { 404, "lock_destroyed" },
            { 500, "resolve_error" },
            { 501, "already_exists" },
            { 502, "max_child_count_violation" },
            { 503, "max_string_length_violation" },
            { 504, "max_attribute_size_violation" },
            { 505, "max_key_length_violation" },
            { 600, "no_such_snapshot" },
            { 601, "no_such_changelog" },
            { 602, "invalid_epoch" },
            { 603, "invalid_version" },
            { 609, "out_of_order_mutations" },
            { 610, "invalid_snapshot_version" },
            { 700, "all_target_nodes_failed" },
            { 701, "send_blocks_failed" },
            { 702, "no_such_session" },
            { 703, "session_already_exists" },
            { 704, "chunk_already_exists" },
            { 705, "window_error" },
            { 706, "block_content_mismatch" },
            { 707, "no_such_block" },
            { 708, "no_such_chunk" },
            { 710, "no_location_available" },
            { 711, "io_error" },
            { 712, "master_communication_failed" },
            { 713, "no_such_chunk_tree" },
            { 714, "master_not_connected" },
            { 716, "chunk_unavailable" },
            { 717, "no_such_chunk_list" },
            { 718, "write_throttling_active" },
            { 719, "no_such_medium" },
            { 720, "optimistic_lock_failure" },
            { 721, "invalid_block_checksum" },
            { 722, "block_out_of_range" },
            { 723, "object_not_replicated" },
            { 724, "missing_extension" },
            { 725, "bandwidth_throttling_failed" },
            { 726, "reader_timeout" },
            { 800, "invalid_election_state" },
            { 801, "invalid_leader" },
            { 802, "invalid_election_epoch" },
            { 900, "authentication_error" },
            { 901, "authorization_error" },
            { 902, "account_limit_exceeded" },
            { 903, "user_banned" },
            { 904, "request_queue_size_limit_exceeded" },
            { 905, "no_such_account" },
            { 906, "safe_mode_enabled" },
            { 1000, "prerequisite_check_failed" },
            { 1100, "config_creation_failed" },
            { 1101, "abort_by_scheduler" },
            { 1102, "resource_overdraft" },
            { 1103, "waiting_job_timeout" },
            { 1104, "slot_not_found" },
            { 1105, "job_environment_disabled" },
            { 1106, "job_proxy_connection_failed" },
            { 1107, "artifact_copying_failed" },
            { 1108, "node_directory_preparation_failed" },
            { 1109, "slot_location_disabled" },
            { 1110, "quota_setting_failed" },
            { 1111, "root_volume_preparation_failed" },
            { 1112, "not_enough_disk_space" },
            { 1113, "artifact_download_failed" },
            { 1120, "job_proxy_failed" },
            { 1200, "memory_limit_exceeded" },
            { 1201, "memory_check_failed" },
            { 1202, "job_time_limit_exceeded" },
            { 1203, "unsupported_job_type" },
            { 1204, "job_not_prepared" },
            { 1205, "user_job_failed" },
            { 1300, "local_chunk_reader_failed" },
            { 1301, "layer_unpacking_failed" },
            { 1500, "aborted" },
            { 1501, "resolve_timed_out" },
            { 1600, "no_such_node" },
            { 1601, "invalid_state" },
            { 1602, "no_such_network" },
            { 1603, "no_such_rack" },
            { 1604, "no_such_data_center" },
            { 1700, "transaction_lock_conflict" },
            { 1701, "no_such_tablet" },
            { 1702, "tablet_not_mounted" },
            { 1703, "all_writes_disabled" },
            { 1704, "invalid_mount_revision" },
            { 1705, "table_replica_already_exists" },
            { 1706, "invalid_tablet_state" },
            { 1707, "table_mount_info_not_ready" },
            { 1708, "tablet_snapshot_expired" },
            { 1709, "query_input_row_count_limit_exceeded" },
            { 1710, "query_output_row_count_limit_exceeded" },
            { 1711, "query_expression_depth_limit_exceeded" },
            { 1800, "shell_exited" },
            { 1801, "shell_manager_shut_down" },
            { 1900, "too_many_concurrent_requests" },
            { 1910, "job_archive_unavailable" },
            { 1915, "api_no_such_operation" },
            { 2000, "data_slice_limit_exceeded" },
            { 2001, "max_data_weight_per_job_exceeded" },
            { 2002, "max_primary_data_weight_per_job_exceeded" },
            { 2100, "proxy_banned" },
            { 4400, "agent_call_failed" },
            { 4304, "connection_reset_by_peer" },
            { 4311, "connection_refused" },
            { 4410, "no_online_node_to_schedule_job" },
            { 4415, "materialization_failed" },
            { 11000, "no_such_transaction" },
            { 13000, "failed_to_start_container" },
            { 17000, "job_is_not_running" }
    };
}

TString NErrorUtils::ToString(NYT::TErrorCode errorCode) {
    int errorCodeInt = static_cast<int>(errorCode);
    auto it = ERROR_CODE_TO_STRING.find(errorCodeInt);

    return (it == ERROR_CODE_TO_STRING.end()) ? ::ToString(errorCodeInt) : it->second;
}
