#pragma once

#include <crypta/lib/native/time/shifted_clock.h>
#include <util/string/builder.h>
#include <util/string/join.h>
#include <util/string/split.h>

namespace NCrypta {
    namespace {
        const char* const DELIMETER = "_";
    }

    class TTimedSuffixGenerator {
        public:
            TTimedSuffixGenerator(TInstant instant)
                : Instant(instant)
            {
            }

            TTimedSuffixGenerator()
                : TTimedSuffixGenerator(TShiftedClock::Now())
            {
            }

            template <typename T>
            TString AppendSuffix(const T& prefix) {
                return TStringBuilder() << prefix << DELIMETER << ToString(Instant.Seconds());
            }

            template <typename T>
            static T RemoveSuffix(const TString& s) {
                TVector<TString> parts;
                Split(s, DELIMETER, parts);
                Y_ENSURE(parts.size() > 1);
                parts.pop_back();
                return FromString<T>(JoinSeq(DELIMETER, parts));
            }

        private:
            TInstant Instant;
    };
}
