#include "timed_yt_path_generator.h"

#include <util/string/cast.h>
#include <util/string/subst.h>

namespace NCrypta {
    TTimedYtPathGenerator::TTimedYtPathGenerator(TInstant instant)
        : Instant(instant)
    {
    }

    TTimedYtPathGenerator::TTimedYtPathGenerator()
        : TTimedYtPathGenerator(TShiftedClock::Now())
    {
    }

    NYT::TYPath TTimedYtPathGenerator::GetPath(const NYT::TYPath& dir, TString nameFormat) const {
        SubstGlobal(nameFormat, "{ts}", ToString(Instant.Seconds()));
        return NYT::JoinYPaths(dir, nameFormat);
    }

    TInstant TTimedYtPathGenerator::GetInstant() const {
        return Instant;
    }
}
