#pragma once

#include <yt/yt/core/ytree/yson_serializable.h>

namespace NCrypta::NYsonUtils {
    template<typename TYsonSerializableDerived>
    ::NYT::TIntrusivePtr<TYsonSerializableDerived> LoadFromStream(IInputStream& stream) {
        auto config = NYT::New<TYsonSerializableDerived>();
        const auto& node = NYT::NYTree::ConvertToNode(&stream);
        config->Load(node);
        return config;
    }

    template<typename TYsonSerializableDerived>
    ::NYT::TIntrusivePtr<TYsonSerializableDerived> LoadFromFile(const TString& filename) {
        TIFStream istream(filename);
        return LoadFromStream<TYsonSerializableDerived>(istream);
    }
}
