import logging
import nirvana.job_context as nv

from crypta.lib.python.swagger import swagger

logger = logging.getLogger(__name__)


def download_model(crypta_api_url, crypta_api_token, tag=''):
    api = swagger(crypta_api_url, crypta_api_token)
    request = api.lab.getModelFileByTag(tag=tag)
    result = request.result()
    return result


def main():
    ctx = nv.context()
    params = ctx.get_parameters()
    outputs = ctx.get_outputs()

    crypta_api_url = params.get('crypta-api-url')
    crypta_api_token = params.get('crypta-api-token')
    tag = params.get('tag', '')

    result = download_model(crypta_api_url, crypta_api_token, tag=tag)

    with open(outputs.get('model'), 'wb') as fh:
        fh.write(result)


if __name__ == "__main__":
    main()
