#include "vectorize_email.h"

float NEmailGender::ConvertChar(const char c) {
    auto converted = SYMBOL_MAPPING.find(c);
    if (converted == SYMBOL_MAPPING.end()) {
        return -1.0;
    }
    return converted->second;
}

bool NEmailGender::ConvertString(const TString& input, TVector<float>& output) {
    output.clear();
    auto atPlace = input.find('@');
    if (atPlace == TString::npos) {
        atPlace = input.size();
    }
    const TString login = input.substr(0, atPlace);
    for (const auto c : login) {
        auto converted = ConvertChar(c);
        if (converted >= 0) {
            output.push_back(converted);
        }
        if (output.size() >= MAX_LEN) {
            return true;
        }
    }
    return !output.empty();
}
