#pragma once

#include <util/generic/vector.h>
#include <util/generic/hash.h>
#include <util/stream/str.h>

namespace NEmailGender {
    constexpr ui32 MAX_LEN = 20;
    const THashMap<char, float> SYMBOL_MAPPING = {
        { '$', 0.0 }, { '0', 1.0 }, { '4', 2.0 }, { '8', 3.0 }, { '<', 4.0 }, { '\\', 5.0 }, { '`', 6.0 },
        { 'd', 7.0 }, { 'h', 8.0 }, { 'l', 9.0 }, { 'p', 10.0 }, { 't', 11.0 }, { 'x', 12.0 }, { '#', 13.0 },
        { '\'', 14.0 }, { '+', 15.0 }, { '3', 16.0 }, { '7', 17.0 }, { '?', 18.0 }, { '_', 19.0 }, { 'c', 20.0 },
        { 'g', 21.0 }, { 'k', 22.0 }, { 'o', 23.0 }, { 's', 24.0 }, { 'w', 25.0 }, { '&', 26.0 }, { '*', 27.0 },
        { '.', 28.0 }, { '2', 29.0 }, { '6', 30.0 }, { ':', 31.0 }, { '>', 32.0 }, { '^', 33.0 }, { 'b', 34.0 },
        { 'f', 35.0 }, { 'j', 36.0 }, { 'n', 37.0 }, { 'r', 38.0 }, { 'v', 39.0 }, { 'z', 40.0 }, { '!', 41.0 },
        { '%', 42.0 }, { ')', 43.0 }, { '-', 44.0 }, { '1', 45.0 }, { '5', 46.0 }, { '9', 47.0 }, { 'a', 48.0 },
        { 'e', 49.0 }, { 'i', 50.0 }, { 'm', 51.0 }, { 'q', 52.0 }, { 'u', 53.0 }, { 'y', 54.0 }};
    const ui32 DICT_SIZE = SYMBOL_MAPPING.size();
    float ConvertChar(char c);
    bool ConvertString(const TString& input, TVector<float>& output);
};
