try:
    from tensorflow.contrib.keras import models
    from tensorflow.contrib.keras import layers
except ImportError:
    pass

ACTIVATION = 'tanh'
EMBEDDING_SIZE = 20


def build_model(dict_size, max_seq_len, domain_size):
    login_input = layers.Input(shape=(max_seq_len,), name='login_input')

    embedding = layers.Embedding(dict_size, EMBEDDING_SIZE,
                                 input_length=max_seq_len)(login_input)

    trigram = layers.ZeroPadding1D(padding=1)(embedding)
    trigram = layers.Conv1D(32, kernel_size=3)(trigram)
    trigram = layers.Activation(ACTIVATION)(trigram)
    trigram = layers.MaxPooling1D(pool_size=2)(trigram)

    middle = layers.ZeroPadding1D(padding=1)(trigram)
    middle = layers.Conv1D(64, kernel_size=3)(middle)
    middle = layers.Activation(ACTIVATION)(middle)
    middle = layers.MaxPooling1D(pool_size=2)(middle)

    top = layers.ZeroPadding1D(padding=1)(middle)
    top = layers.Conv1D(128, kernel_size=3)(top)
    top = layers.Activation(ACTIVATION)(top)
    top = layers.MaxPooling1D(pool_size=5)(top)

    flat = layers.Flatten()(top)

    domain_input = layers.Input(shape=(domain_size,), name='domain_input')
    desc_with_domain = layers.concatenate([flat, domain_input])

    dense = layers.Dense(32, activation='tanh')(desc_with_domain)
    net_output = layers.Dense(1, activation='sigmoid')(dense)

    return models.Model(inputs=[login_input, domain_input], outputs=net_output)
