#include "vectorize_email.h"

float NEmailOrganization::ConvertChar(const char c) {
    auto converted = SYMBOL_MAPPING.find(c);
    if (converted == SYMBOL_MAPPING.end()) {
        return -1.0;
    }
    return converted->second;
}

ui32 NEmailOrganization::ConvertDomain(const TString& domain) {
    auto converted = DOMAIN_MAPPING.find(domain);
    if (converted == DOMAIN_MAPPING.end()) {
        return DOMAIN_DICT_SIZE - 1;
    }
    return converted->second;
}

bool NEmailOrganization::ConvertString(const TString& input, TVector<float>& loginVector, TVector<float>& domainVector) {
    loginVector.clear();
    domainVector.clear();
    auto atPlace = input.find('@');
    if (atPlace == TString::npos) {
        atPlace = input.size();
    }
    const TString login = LegacySubstr(input, 0, atPlace);
    const TString domain = LegacySubstr(input, atPlace + 1, input.size());
    for (const auto c : login) {
        auto converted = ConvertChar(c);
        if (converted >= 0) {
            loginVector.push_back(converted);
        }
        if (loginVector.size() >= MAX_LEN) {
            break;
        }
    }
    domainVector.resize(DOMAIN_DICT_SIZE);
    domainVector[ConvertDomain(domain)] = 1;
    return !loginVector.empty();
}
