#include "vectorize_login.h"

float NLoginGender::ConvertChar(const char c) {
    auto converted = SYMBOL_MAPPING.find(c);
    if (converted == SYMBOL_MAPPING.end()) {
        return -1.0;
    }
    return converted->second;
}

bool NLoginGender::ConvertString(const TString& input, TVector<float>& output) {
    output.clear();
    for (const auto c : input) {
        auto converted = ConvertChar(c);
        if (converted >= 0) {
            output.push_back(converted);
        }
        if (output.size() >= MAX_LEN) {
            return true;
        }
    }
    return !output.empty();
}
