from util.generic.vector cimport TVector
from util.generic.string cimport TString
from libcpp cimport bool
from util.system.types cimport ui32
import numpy as np

cdef extern from 'crypta/lib/nirvana/login_organization/vectorize/vectorize_login.h' \
        namespace 'NLoginOrganization':
    bool ConvertString(const TString&, const TVector[float]&)
    ui32 _MAX_LEN 'NLoginOrganization::MAX_LEN'
    ui32 _DICT_SIZE 'NLoginOrganization::DICT_SIZE'

MAX_LEN = _MAX_LEN
DICT_SIZE = _DICT_SIZE


def vectorize_one(login):
    cdef TString cpp_login
    cdef TVector[float] cpp_vectorized
    if type(login) == str:
        cpp_login = login
        ConvertString(cpp_login, cpp_vectorized)
    result = np.asarray(cpp_vectorized, dtype=np.float16)
    result = np.pad(result, (0, MAX_LEN - result.size), 'constant')
    return result
