import logging
import nirvana.job_context as nv

from crypta.lib.python.swagger import swagger

logger = logging.getLogger(__name__)


def upload_model(path, description, crypta_api_url, crypta_api_token, tag=''):
    api = swagger(crypta_api_url, crypta_api_token)
    request = api.lab.createModel(file=open(path).read(),
                                  description=description)
    result_create = request.result()
    request = api.lab.setTag(id=result_create.id, tag=tag)
    result_tag = request.result()
    return result_create, result_tag


def main():
    ctx = nv.context()
    inputs = ctx.get_inputs()
    params = ctx.get_parameters()
    outputs = ctx.get_outputs()

    path = inputs.get("upload_file")

    crypta_api_url = params.get('crypta-api-url')
    crypta_api_token = params.get('crypta-api-token')

    description = params.get('description')
    tag = params.get('tag', '')

    result_create, result_tag = upload_model(path, description, crypta_api_url, crypta_api_token, tag=tag)

    with open(outputs.get('response'), 'w') as fh:
        fh.write(str(result_create))
    with open(outputs.get('id'), 'w') as fh:
        fh.write(result_create.id)
    with open(outputs.get('tag'), 'w') as fh:
        fh.write(result_tag.tag)


if __name__ == "__main__":
    main()
