#pragma once

#include <crypta/lib/proto/user_data/user_data.pb.h>

#include <util/generic/hash.h>

template <>
struct THash<NLab::TSegment> {
    size_t operator()(const NLab::TSegment& segment) const {
        THash<std::pair<ui32, ui32>> hash;
        return hash(std::make_pair(segment.GetKeyword(), segment.GetID()));
    }
};

template <>
struct TEqualTo<NLab::TSegment> {
    size_t operator()(const NLab::TSegment& lhs, const NLab::TSegment& rhs) const {
        return (lhs.GetKeyword() == rhs.GetKeyword()) && (lhs.GetID() == rhs.GetID());
    }
};
