import six

from util.generic.hash cimport THashMap
from util.generic.ptr cimport MakeHolder
from util.generic.string cimport TString

from crypta.lib.native.bigb_catboost_applier.catboost_features_calculator cimport (
    TCatboostFeaturesCalculator as TCatboostFeaturesCalculatorImpl,
    Profile as ProfileImpl,
)


cdef class TCatboostFeaturesCalculator:
    def __init__(self, features_mapping, counters_to_features, keywords_to_features):
        cdef THashMap[TString, size_t] cpp_features_mapping
        for key, value in six.iteritems(features_mapping):
            cpp_features_mapping[six.ensure_binary(key)] = value

        cdef THashMap[size_t, TString] cpp_counters_to_features
        for key, value in six.iteritems(counters_to_features):
            cpp_counters_to_features[key] = six.ensure_binary(value)

        cdef THashMap[size_t, TString] cpp_keywords_to_features
        for key, value in six.iteritems(keywords_to_features):
            cpp_keywords_to_features[key] = six.ensure_binary(value)

        self._impl = MakeHolder[TCatboostFeaturesCalculatorImpl](cpp_features_mapping, cpp_counters_to_features, cpp_keywords_to_features)

    def PrepareFloatFeatures(self, profile):
        cdef ProfileImpl profile_impl
        profile_impl.ParseFromString(profile.SerializeToString())
        return self._impl.Get().PrepareFloatFeatures(profile_impl)

    def PrepareTextFeatures(self, profile):
        cdef ProfileImpl profile_impl
        profile_impl.ParseFromString(profile.SerializeToString())
        return six.ensure_str(
            self._impl.Get().PrepareTextFeatures(profile_impl),
            encoding='utf-8',
            errors='ignore',
        )
