from crypta.lib.python.bigb_catboost_applier import fields
from crypta.lib.native.bigb_catboost_applier.proto.catboost_features_mapping_pb2 import TCatboostFeaturesMapping

compute_features_mapping_query = """
$bindings = (
    SELECT
        DictKeys(Yson::ConvertToDoubleDict(bindings)) AS bindings
    FROM `{train_sample_table}`
);

$bindings = (
    SELECT
        category_id,
        COUNT(*) AS users_cnt
    FROM $bindings
    FLATTEN LIST BY bindings AS category_id
    GROUP BY category_id
);

$bindings = (
    SELECT
        'bindings_' || CAST(cat_counts.category_id AS String) AS feature,
        ROW_NUMBER() OVER w - 1 AS feature_index,
        cats_desc.Description AS description
    FROM `{bm_categories_description_table}` AS cats_desc
    INNER JOIN $bindings AS cat_counts
    ON CAST(cats_desc.BMCategoryID AS String) == cat_counts.category_id
    WINDOW w AS (ORDER BY cat_counts.users_cnt DESC)
    ORDER BY feature_index
    LIMIT {bm_categories_to_take}
);

$os = (
    SELECT
        os,
        COUNT(*) AS users_cnt
    FROM `{train_sample_table}`
    FLATTEN LIST BY operating_systems AS os
    GROUP BY os
);

$os = (
    SELECT
        'operating_systems_' || CAST(os_counts.os AS String) AS feature,
        ROW_NUMBER() OVER w + {bm_categories_to_take} - 1 AS feature_index,
        os_desc.Description AS description
    FROM `{os_description_table}` AS os_desc
    INNER JOIN $os AS os_counts
    ON os_desc.DetailedDeviceType == os_counts.os
    WHERE os_desc.Description != ''
    WINDOW w AS (ORDER BY os_counts.users_cnt DESC)
    ORDER BY feature_index
    LIMIT {operating_systems_to_take}
);

$mobile_models = (
    SELECT
        mobile_model,
        COUNT(*) AS users_cnt
    FROM `{train_sample_table}`
    FLATTEN LIST BY mobile_models AS mobile_model
    GROUP BY mobile_model
);

$mobile_models = (
    SELECT
        'mobile_models_' || mobile_model AS feature,
        ROW_NUMBER() OVER w + {bm_categories_to_take} + {operating_systems_to_take} - 1 AS feature_index,
        mobile_model AS description
    FROM $mobile_models
    WINDOW w AS (ORDER BY users_cnt DESC)
    ORDER BY feature_index
    LIMIT {mobile_models_to_take}
);

$regions = (
    SELECT
        region,
        COUNT(*) AS users_cnt
    FROM `{train_sample_table}`
    FLATTEN LIST BY regions AS region
    WHERE region IS NOT NULL
    GROUP BY region
);

$regions = (
    SELECT
        'regions_' || CAST(region AS String) AS feature,
        ROW_NUMBER() OVER w + {bm_categories_to_take} + {operating_systems_to_take}
            + {mobile_models_to_take} - 1 AS feature_index,
        CAST(region AS String) || ':' || Geo::RegionById(CAST(region AS Int32)).en_name AS description
    FROM $regions
    WINDOW w AS (ORDER BY users_cnt DESC)
    ORDER BY feature_index
    LIMIT {regions_to_take}
);


$union_features = (
    SELECT *
    FROM $bindings
UNION ALL
    SELECT *
    FROM $os
UNION ALL
    SELECT *
    FROM $mobile_models
UNION ALL
    SELECT *
    FROM $regions
);

INSERT INTO `{output_table}`
WITH TRUNCATE

SELECT *
FROM $union_features
ORDER BY feature_index;
"""


def get_proto_features_mapping(yt_client, features_mapping_table_path, counters_to_features, keywords_to_features):
    features_mapping = TCatboostFeaturesMapping()
    for row in yt_client.read_table(features_mapping_table_path):
        features_mapping.FeatureToIndex[row[fields.FEATURE]] = row[fields.FEATURE_INDEX]
    for key in counters_to_features:
        features_mapping.CounterToPrefix[key] = counters_to_features[key]
    for key in keywords_to_features:
        features_mapping.KeywordToPrefix[key] = keywords_to_features[key]
    return features_mapping


def get_features_mapping(yt_client, features_mapping_table_path):
    features_mapping = dict()
    float_features_description = list()
    for row in yt_client.read_table(features_mapping_table_path):
        features_mapping[row[fields.FEATURE]] = row[fields.FEATURE_INDEX]
        float_features_description.append(row[fields.DESCRIPTION])
    return features_mapping, float_features_description
